/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 bit up/down (dnup) counter with gate enable (gn), 
		 async clear (clrn), async set (setn) and sync load (ldn)
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_count8 (cout, q, clk, clrn, d, dnup, gn, ldn, setn);
  output[7:0]	q;
  output	cout;
  input[7:0]	d;
  input		clk, clrn, dnup, gn, ldn, setn;

  reg[7:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
  buf #1 (q[4], q_int[4]);
  buf #1 (q[5], q_int[5]);
  buf #1 (q[6], q_int[6]);
  buf #1 (q[7], q_int[7]);
 
  assign cout = ( ( dnup & !gn & ( q_int == 8'b0 ) ) | ( !dnup & !gn & ( q_int == 8'b11111111 ) ) );

  always @(posedge clk)
	/* load */
	if ( !ldn )
		q_int = d;
	/* decrement */
	else if ( dnup & !gn )
		q_int = q_int - 1;
	/* increment */
	else if ( !dnup & !gn )
		q_int = q_int + 1;

  always @(clrn or setn)
	if (!clrn & setn) /* async clear */
		assign q_int = 8'b0;
	else if (clrn & !setn) /* async load */
		assign q_int = d;
	else if (!clrn & !setn) /* illegal, do nothing */
		assign q_int = q_int;
	else
		deassign q_int;

  specify

`ifdef SYNTH
	specparam area = 14;
`endif

  endspecify
 
endmodule
`endcelldefine



